/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.export.VWExportImportTree;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.TreePath;

public class VWExportImportTreeMouseAdapter
extends MouseAdapter {
    private VWExportImportTree m_tree = null;
    private VWConfigBaseNode m_focus = null;
    private Dimension m_checkBoxDim;

    public VWExportImportTreeMouseAdapter(VWExportImportTree tree) {
        this.m_tree = tree;
        this.m_focus = (VWConfigBaseNode)this.m_tree.getModel().getRoot();
    }

    public void setCheckBoxDim(Dimension dm) {
        this.m_checkBoxDim = dm;
    }

    public void mousePressed(MouseEvent event) {
        int selRow;
        if (!event.isPopupTrigger() && (selRow = this.m_tree.getRowForLocation(event.getX(), event.getY())) != -1) {
            this.m_tree.setSelectionRow(selRow);
            this.m_tree.requestFocus();
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 1) {
            Rectangle pathBounds;
            Point p = event.getPoint();
            TreePath closestPath = this.m_tree.getClosestPathForLocation(p.x, p.y);
            if (closestPath != null && (pathBounds = this.m_tree.getPathBounds(closestPath)) != null && p.x >= pathBounds.x && p.x < pathBounds.x + pathBounds.width && p.y >= pathBounds.y && p.y < pathBounds.y + pathBounds.height && p.x < pathBounds.x + this.m_checkBoxDim.width) {
                this.m_focus.updateExportSelection();
                this.m_tree.updateUI();
            }
        }
    }

    protected void setFocus(VWConfigBaseNode node) {
        this.m_focus = node;
    }
}

